/*
 * Decompiled with CFR 0.152.
 */
package com.megacrit.cardcrawl.screens;

import com.badlogic.gdx.graphics.g2d.SpriteBatch;
import com.megacrit.cardcrawl.cards.AbstractCard;
import com.megacrit.cardcrawl.characters.AbstractPlayer;
import com.megacrit.cardcrawl.core.CardCrawlGame;
import com.megacrit.cardcrawl.core.Settings;
import com.megacrit.cardcrawl.dungeons.AbstractDungeon;
import com.megacrit.cardcrawl.helpers.InputHelper;
import com.megacrit.cardcrawl.helpers.TipTracker;
import com.megacrit.cardcrawl.localization.UIStrings;
import com.megacrit.cardcrawl.rewards.RewardItem;
import com.megacrit.cardcrawl.ui.FtueTip;
import com.megacrit.cardcrawl.unlock.UnlockTracker;
import com.megacrit.cardcrawl.vfx.FastCardObtainEffect;
import java.util.ArrayList;
import java.util.HashMap;

public class CardRewardScreen {
    private static final UIStrings uiStrings = CardCrawlGame.languagePack.getUIString("CardRewardScreen");
    public static final String[] TEXT = CardRewardScreen.uiStrings.TEXT;
    private static final float PAD_X = 40.0f * Settings.scale;
    private static final float CARD_TARGET_Y = (float)Settings.HEIGHT * 0.45f;
    public ArrayList<AbstractCard> rewardGroup;
    public AbstractCard codexCard = null;
    public boolean onCardSelect = true;
    public boolean hasTakenAll = false;
    public boolean cardOnly = false;
    public RewardItem rItem = null;
    private boolean codex = false;
    private String header = "";

    public void update() {
        this.cardSelectUpdate();
    }

    private void cardSelectUpdate() {
        AbstractCard hoveredCard = null;
        for (AbstractCard c : this.rewardGroup) {
            c.update();
            c.updateHoverLogic();
            if (c.hb.justHovered) {
                CardCrawlGame.sound.playV("CARD_OBTAIN", 0.4f);
            }
            if (!c.hb.hovered) continue;
            hoveredCard = c;
        }
        if (hoveredCard != null && InputHelper.justClickedLeft) {
            hoveredCard.hb.clickStarted = true;
        }
        if (hoveredCard != null && hoveredCard.hb.clicked) {
            hoveredCard.hb.clicked = false;
            AbstractDungeon.overlayMenu.cancelButton.hide();
            if (!this.codex) {
                HashMap<String, Object> choice = new HashMap<String, Object>();
                ArrayList<String> notpicked = new ArrayList<String>();
                for (AbstractCard card : this.rewardGroup) {
                    if (card == hoveredCard) continue;
                    notpicked.add(card.cardID);
                }
                choice.put("picked", hoveredCard.cardID);
                choice.put("not_picked", notpicked);
                CardCrawlGame.metricData.card_choices.add(choice);
                InputHelper.justClickedLeft = false;
                AbstractDungeon.effectsQueue.add(new FastCardObtainEffect(hoveredCard, hoveredCard.current_x, hoveredCard.current_y));
            } else {
                this.codexCard = hoveredCard;
            }
            if (this.rItem != null) {
                AbstractDungeon.combatRewardScreen.rewards.remove(this.rItem);
                AbstractDungeon.combatRewardScreen.positionRewards();
                if (AbstractDungeon.combatRewardScreen.rewards.isEmpty()) {
                    AbstractDungeon.combatRewardScreen.hasTakenAll = true;
                }
            }
            AbstractDungeon.closeCurrentScreen();
            return;
        }
    }

    public void render(SpriteBatch sb) {
        this.renderCardReward(sb);
    }

    private void renderCardReward(SpriteBatch sb) {
        for (AbstractCard c : this.rewardGroup) {
            c.render(sb);
        }
        for (AbstractCard c : this.rewardGroup) {
            c.renderCardTip(sb);
        }
    }

    public void reopen() {
        AbstractDungeon.screen = AbstractDungeon.CurrentScreen.CARD_REWARD;
        AbstractDungeon.overlayMenu.cancelButton.show(TEXT[0]);
        AbstractDungeon.topPanel.unhoverHitboxes();
        AbstractDungeon.isScreenUp = true;
        AbstractDungeon.dynamicBanner.appear(this.header);
        AbstractDungeon.overlayMenu.proceedButton.hide();
    }

    public void open(ArrayList<AbstractCard> cards, RewardItem rItem, String header) {
        this.codex = false;
        this.rItem = rItem;
        AbstractDungeon.overlayMenu.cancelButton.show(TEXT[0]);
        this.onCardSelect = true;
        AbstractDungeon.topPanel.unhoverHitboxes();
        this.rewardGroup = cards;
        AbstractDungeon.isScreenUp = true;
        AbstractDungeon.screen = AbstractDungeon.CurrentScreen.CARD_REWARD;
        this.header = header;
        AbstractDungeon.dynamicBanner.appear(header);
        AbstractDungeon.overlayMenu.proceedButton.hide();
        AbstractDungeon.overlayMenu.showBlackScreen();
        this.placeCards((float)Settings.WIDTH / 2.0f, CARD_TARGET_Y);
        for (AbstractCard c : cards) {
            UnlockTracker.markCardAsSeen(c.cardID);
        }
        for (AbstractCard c : cards) {
            if (c.type != AbstractCard.CardType.POWER || TipTracker.tips.get("POWER_TIP").booleanValue()) continue;
            AbstractDungeon.ftue = new FtueTip(AbstractPlayer.LABEL[0], AbstractPlayer.MSG[0], (float)Settings.WIDTH / 2.0f - 500.0f * Settings.scale, (float)Settings.HEIGHT / 2.0f, c);
            AbstractDungeon.ftue.type = FtueTip.TipType.POWER;
            TipTracker.neverShowAgain("POWER_TIP");
            AbstractDungeon.overlayMenu.cancelButton.hide();
            break;
        }
    }

    public void codexOpen() {
        this.rItem = null;
        this.codex = true;
        this.codexCard = null;
        AbstractDungeon.overlayMenu.cancelButton.show(TEXT[0]);
        this.onCardSelect = true;
        AbstractDungeon.topPanel.unhoverHitboxes();
        ArrayList<AbstractCard> derp = new ArrayList<AbstractCard>();
        while (derp.size() != 3) {
            boolean dupe = false;
            AbstractCard tmp = AbstractDungeon.returnTrulyRandomCard();
            for (AbstractCard c : derp) {
                if (!c.cardID.equals(tmp.cardID)) continue;
                dupe = true;
                break;
            }
            if (dupe) continue;
            derp.add(tmp.makeCopy());
        }
        this.rewardGroup = derp;
        AbstractDungeon.isScreenUp = true;
        AbstractDungeon.screen = AbstractDungeon.CurrentScreen.CARD_REWARD;
        AbstractDungeon.dynamicBanner.appear(TEXT[1]);
        AbstractDungeon.overlayMenu.showBlackScreen();
        this.placeCards((float)Settings.WIDTH / 2.0f, CARD_TARGET_Y);
        for (AbstractCard c : this.rewardGroup) {
            UnlockTracker.markCardAsSeen(c.cardID);
        }
    }

    private void placeCards(float x, float y) {
        if (this.rewardGroup.size() == 3) {
            this.rewardGroup.get((int)0).target_x = (float)Settings.WIDTH / 2.0f - AbstractCard.IMG_WIDTH - PAD_X;
            this.rewardGroup.get((int)1).target_x = (float)Settings.WIDTH / 2.0f;
            this.rewardGroup.get((int)2).target_x = (float)Settings.WIDTH / 2.0f + AbstractCard.IMG_WIDTH + PAD_X;
            this.rewardGroup.get((int)0).target_y = y;
            this.rewardGroup.get((int)1).target_y = y;
            this.rewardGroup.get((int)2).target_y = y;
        } else {
            this.rewardGroup.get((int)0).target_x = (float)Settings.WIDTH / 2.0f - AbstractCard.IMG_WIDTH * 1.5f - PAD_X * 1.5f;
            this.rewardGroup.get((int)1).target_x = (float)Settings.WIDTH / 2.0f - AbstractCard.IMG_WIDTH / 2.0f - PAD_X / 2.0f;
            this.rewardGroup.get((int)2).target_x = (float)Settings.WIDTH / 2.0f + AbstractCard.IMG_WIDTH / 2.0f + PAD_X / 2.0f;
            this.rewardGroup.get((int)3).target_x = (float)Settings.WIDTH / 2.0f + AbstractCard.IMG_WIDTH * 1.5f + PAD_X * 1.5f;
            this.rewardGroup.get((int)0).target_y = y;
            this.rewardGroup.get((int)1).target_y = y;
            this.rewardGroup.get((int)2).target_y = y;
            this.rewardGroup.get((int)3).target_y = y;
        }
        for (AbstractCard c : this.rewardGroup) {
            c.drawScale = 0.75f;
            c.targetDrawScale = 0.75f;
            c.current_x = x;
            c.current_y = y;
        }
    }
}

